/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275d;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class VlanDelete
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8275d.GeneralResources");
    public static final int RASID = 19;
    public static final int RASSUB = 8;
    DestinationPropBook myBook;
    JdmBrowser browser;
    NavigationContext myContext;
    MessageBox messageToUser;
    boolean okayToDelete = true;
    Integer VlanID;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        boolean bl = true;
        ModelInfo modelInfo = null;
        String string = "setDefaults";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string);
        }
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "Can't get browser- can't proceed with create");
            }
            bl = false;
        }
        if (bl) {
            modelInfo = jDMWizardInfo.getCurrentRow();
            Hashtable hashtable = jDMWizardInfo.getItems();
            if (modelInfo != null && modelInfo.get("Index.Vlan") instanceof Integer) {
                this.VlanID = (Integer)modelInfo.get("Index.Vlan");
                hashtable.put("deleteVlanID", this.VlanID);
                hashtable.put("deleteVlanName", modelInfo.get("Panel.VlanName"));
                this.okayToDelete = true;
                this.browser.displayMsg(VlanDelete.getNLSString("WZ_deleteConfirm"));
            } else {
                hashtable.put("deleteVlanID", " ");
                hashtable.put("deleteVlanName", " ");
                this.okayToDelete = false;
                this.browser.displayMsg(VlanDelete.getNLSString("VD_NoVlan"));
            }
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string);
        }
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl = true;
        GenModel genModel = null;
        String string = "proceed";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string);
        }
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "Can't get browser- can't proceed with create");
            }
            bl = false;
        }
        if (bl && !this.okayToDelete) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "Table is empty. No Vlan can be selected for deletion.");
            }
            this.browser.displayMsg(VlanDelete.getNLSString("VD_NoVlan"));
            this.messageToUser = new MessageBox(this.browser.getFrame(), VlanDelete.getNLSString("VD_Error"), VlanDelete.getNLSString("VD_NoVlan"), true);
            bl = false;
        } else {
            try {
                genModel = jDMWizardInfo.getModel();
                ModelInfo modelInfo = new ModelInfo();
                modelInfo.add("Index.Vlan", this.VlanID);
                modelInfo.add("Panel.VlanCommand", new Integer(2));
                modelInfo = genModel.setInfo("Panel", modelInfo);
                Enumeration enumeration = modelInfo.getItemIds();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Serializable serializable = modelInfo.get(string2);
                    if (!(serializable instanceof SpecialValue)) continue;
                    if (RAS.isEnabled(19, 8)) {
                        RAS.trace(19, 8, this, string, "Set to delete Vlan id " + this.VlanID + " failed");
                    }
                    this.browser.displayMsg(VlanDelete.getNLSString("WZ_rejectDelete"));
                    this.messageToUser = new MessageBox(this.browser.getFrame(), VlanDelete.getNLSString("VD_Error"), VlanDelete.getNLSString("WZ_rejectDelete"), true);
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string, "Error setting info.");
                }
                RAS.logException(19, 8, this, string, exception);
                this.browser.displayMsg(VlanDelete.getNLSString("WZ_badSetDelete"));
                this.messageToUser = new MessageBox(this.browser.getFrame(), VlanDelete.getNLSString("VD_error"), VlanDelete.getNLSString("WZ_badSetDelete"), true);
                bl = false;
            }
        }
        if (bl) {
            this.browser.displayMsg(VlanDelete.getNLSString("VD_deleteOK"));
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string);
        }
        return bl;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

